class Vector:
    def __init__(self, x, y):
        self.x = x
        self.y = y

    def __add__(self, other):
        """Dodawanie dwóch wektorów za pomocą operatora +"""
        return Vector(
            self.x + other.x,
            self.y + other.y,
        )

    def __sub__(self, other):
        """Odejmowanie dwóch wektorów za pomocą operatora -"""
        return Vector(
            self.x - other.x,
            self.y - other.y,
        )

    def __repr__(self):
        """Zwracanie tekstowej reprezentacji wektora"""
        return f"<Vector: x={self.x}, y={self.y}>"

    def __eq__(self, other):
        """Sprawdzanie, czy dwa wektory są sobie równe"""
        return self.x == other.x and self.y == other.y
